﻿
Partial Class rejectoffer
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    'used to store the offer no of the offer to be rejected
    Dim OfferNo As Integer

    Protected Sub btnNo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnNo.Click
        'redirect back to the swap manager
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub btnYes_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnYes.Click
        'reject the offer
        Call RejectOffer()
        'redirect back to the swap manager
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'make sure that this page is being accessed by a logged in user
        Call CheckLogin()
        'get the offer number of the offer to be rejected
        OfferNo = Session("OfferNo")
    End Sub

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub

    Sub RejectOffer()
        'sends an email to the person making the offer and delete the offer from the database
        '
        'var to store the email address of the person making the offer
        Dim OfferEMail As String
        'var to store the user name of the person making the offer
        Dim OfferUserName As String
        'var to store the title of the offer
        Dim OfferTitle As String
        'declare an instance of my email object
        Dim AnEMail As New MyEMail
        'var to store successful sending of the email
        Dim Success As Boolean
        'get the email address of the person making the offer
        OfferEMail = GetOfferEMail(OfferNo)
        'get the user name of the person making the offer
        OfferUserName = GetOfferUserName(OfferNo)
        'get the title of the item on offer
        OfferTitle = GetOfferTitle(OfferNo)
        'send a rejection email to the person who made the offer
        Success = AnEMail.SendEMail("dvd.mdb", OfferEMail, "Your swap shop offer", ThisSite.SiteOwner & " has declined your offer of " & OfferTitle)
        'find the record for this offer in the database
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the record is found
        If AnOffer.Count = 1 Then
            'delete it
            AnOffer.RemoveRecord(0)
            'save the changes
            AnOffer.SaveChanges()
        End If
    End Sub

    Function GetOfferEMail(ByVal OfferNo As Integer) As String
        'this function looks up the offer no in the offer table to find the user who made the offer
        'it then looks up that person's user no in the users table to find their email address
        'it returns their email address
        '
        'var to store the user no of the person who made the offer
        Dim UserNo As Integer
        'var to store the email address of the person who made the offer
        Dim EMail As String
        'open the database to find the record for this offer
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the record is found
        If AnOffer.Count = 1 Then
            'get the user no of the person making the offer
            UserNo = AnOffer.RecordNumber(0).Item("UserNo")
            'get the record for this user
            Dim AUser As New DatabaseTable("dvd.mdb", "select * from users where userno=" & UserNo, "#PN", "#PW")
            'if the user is found
            If AUser.Count = 1 Then
                'get their email address
                EMail = AUser.RecordNumber(0).Item("EMail")
                'return the email address
                Return EMail
            Else
                'return a blank string
                Return ""
            End If
        Else
            'return a blank string
            Return ""
        End If
    End Function

    Function GetOfferUserName(ByVal OfferNo As Integer) As String
        'this function returns the full name of the person making an offer
        'it acceptes one parameter which is the offer number
        'it first looks up the offer in the offer table to find the user no of the person making the offer
        'it next looks in the users table to find the name of the person
        '
        'var to store the user number of the person making the offer
        Dim UserNo As Integer
        'var to store the full name of the person making the offer
        Dim FullName As String
        'open the database locating the record for this offer
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the offer is found
        If AnOffer.Count = 1 Then
            'get the id of the user making the offer
            UserNo = AnOffer.RecordNumber(0).Item("UserNo")
            'open the database locating the user record for this person
            Dim AUser As New DatabaseTable("dvd.mdb", "select * from users where userno=" & UserNo, "#PN", "#PW")
            'if the record is found
            If AUser.Count = 1 Then
                'get the full name of the person making the offer
                FullName = AUser.RecordNumber(0).Item("FirstName") & " " & AUser.RecordNumber(0).Item("LastName")
                'retuurn the full name
                Return FullName
            Else
                'return a blank string
                Return ""
            End If
        Else
            'return a blank string
            Return ""
        End If
    End Function

    Function GetOfferTitle(ByVal OfferNo As Integer) As String
        'this function looks up the title for an offer based on the offer no
        '
        'var to store the title of the offer
        Dim Title As String
        'look up the offer in the database
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the record is found
        If AnOffer.Count = 1 Then
            'get the title
            Title = AnOffer.RecordNumber(0).Item("Title")
            'return the title
            Return Title
        Else
            'return the title
            Return ""
        End If
    End Function
End Class
